import RPi.GPIO as GPIO
import time
import sys

class MCP3208:

    spi_ss=3
    spi_clk=19
    spi_miso=21
    spi_mosi=23
    wait=0.01
    
    def __init__(self,ss,clk=19,miso=21,mosi=23,w=0.01):

        self.spi_ss=ss
        self.spi_clk=clk
        self.spi_miso=miso
        self.spi_mosi=mosi
        self.wait=w

        GPIO.setwarnings(False)
        GPIO.setmode(GPIO.BOARD)
        GPIO.setup(self.spi_mosi, GPIO.OUT)
        GPIO.setup(self.spi_miso, GPIO.IN)
        GPIO.setup(self.spi_clk, GPIO.OUT)
        GPIO.setup(self.spi_ss,  GPIO.OUT)

        GPIO.output(self.spi_ss,   False)
        time.sleep(self.wait)

        GPIO.output(self.spi_ss,   True)
        time.sleep(self.wait)

        GPIO.output(self.spi_clk, True)
        time.sleep(self.wait)

    def write(self,val):
        GPIO.output(self.spi_clk,  False)
        time.sleep(self.wait)
        if(val==0):
            GPIO.output(self.spi_mosi, False)
        else:
            GPIO.output(self.spi_mosi, True)
        time.sleep(self.wait)
        GPIO.output(self.spi_clk,  True)
        time.sleep(self.wait)

    def read(self):
        GPIO.output(self.spi_clk, False)
        time.sleep(self.wait)
        GPIO.output(self.spi_clk, True)
        time.sleep(self.wait)
        out=0
        if (GPIO.input(self.spi_miso)):
            out=1
        return out

    def readValue(self,ch):
        #initialize
        GPIO.output(self.spi_ss,   False)
        time.sleep(self.wait)

        #start bit,single ended
        self.write(1)
        self.write(1)

        #select channel
        if(ch==0):
            self.write(0)
            self.write(0)
            self.write(0)
        elif(ch==1):
            self.write(0)
            self.write(0)
            self.write(1)
        elif(ch==2):
            self.write(0)
            self.write(1)
            self.write(0)
        elif(ch==3):
            self.write(0)
            self.write(1)
            self.write(1)
        elif(ch==4):
            self.write(1)
            self.write(0)
            self.write(0)
        elif(ch==5):
            self.write(1)
            self.write(0)
            self.write(1)
        elif(ch==6):
            self.write(1)
            self.write(1)
            self.write(0)
        elif(ch==7):
            self.write(1)
            self.write(1)
            self.write(1)
        else:
            self.write(0)
            self.write(0)
            self.write(0)
            print "Error : no such channel",ch
        
        #wiat one clock
        self.write(1)
			

        out=self.read()
        if(out==1):
            print "Error: should be null"
		
        value = 0
        for k in range(0,12):
            value <<= 1
            out=self.read()
            if (out==1):
                value |= 0x1
        #end process
        GPIO.output(self.spi_clk, False)
        time.sleep(self.wait)
        GPIO.output(self.spi_ss,   True)
        time.sleep(self.wait)
        GPIO.output(self.spi_clk, True)
        time.sleep(self.wait)

        return value


