makeSigns = ..\bin\makeSigns.py
outsideExcelFile = ..\signs_outside.xlsx
insideExcelFile = ..\signs_inside.xlsx
editFinalSwitch = ..\std_styles\editFinalSwitch.tex
EDITMODE_SRC = ..\std_styles\editMode.tex
FINALMODE_SRC = ..\std_styles\finalMode.tex

platex = platex
dvipdfmx = dvipdfmx
GS_CMD = gswin64c.exe
GS_OPTS = -q -dNOPAUSE -dBATCH -dNoOutputFonts -sDEVICE=pdfwrite -sProcessColorModel=DeviceCMYK -sColorConversionStrategy=CMYK
MOVE_CMD = cmd /c move


.PHONY:	clean editmode finalmode

.PRECIOUS: %.inc

editmode:
	cp $(EDITMODE_SRC) $(editFinalSwitch)

finalmode:
	cp $(FINALMODE_SRC) $(editFinalSwitch)

%.dvi:	%.tex %.inc
	$(platex) $<

%.pdf:	%.dvi
	$(dvipdfmx) -o tmp1.pdf $<
	$(GS_CMD) $(GS_OPTS) -sOutputFile=tmp2.pdf tmp1.pdf
	$(MOVE_CMD) tmp2.pdf $@
	rm tmp1.pdf

clean:
	-rm *.inc
	-rm *.dvi
	-rm *.aux
	-rm *.log
	-rm *.synctex.gz
