#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import codecs
import xlrd

excelFile = sys.argv[1]
sys.stdout = codecs.getwriter('utf_8')(sys.stdout)

book = xlrd.open_workbook(excelFile)
sheet = book.sheet_by_index(0)

building = ''
floor = ''

firstExcelRow = -1
for row in range(sheet.nrows):
    if sheet.cell(row, 0).value == 1:
        firstExcelRow = row
        break

if firstExcelRow < 0:
    print >>sys.stderr, "ERROR: Please enter '1' in the first cell for the first room."
    exit(-1)

for row in range(firstExcelRow, sheet.nrows):
    jpsRoom = sheet.cell(row, 1).value
    bldg    = sheet.cell(row, 2).value
    flr     = sheet.cell(row, 3).value
    originalRoom = sheet.cell(row, 4).value
    entranceSide = sheet.cell(row, 5).value

    if jpsRoom == '':
        continue

    if bldg != '':
        building = bldg

    if flr != '':
        try:
            floor = str(int(float(flr)))
        except UnicodeEncodeError:
            continue

    # print jpsRoom, building, floor, originalRoom
    font = ''
    if jpsRoom[0] == u'休':
        command = '\\freeRoomPlate{'
        jpsRoom = jpsRoom[3:]

    else:
        command = '\\roomPlate{'

    nlines = jpsRoom.count(r'\\') + 1

    if nlines > 1:
        font = 'twoLines'
    
    elif len(jpsRoom) > 3:
        font = 'small'

    else:
        font = 'normal'

    print command + jpsRoom + '}{' + font + '}{' + building, \
            floor + 'F', originalRoom + '}{' + entranceSide + '}'


